/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSceneGraphException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.MediaContainerRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SoundSchedulerAtom;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

abstract class SoundRetained
extends LeafRetained {
    static final int NULL_SOUND = -1;
    MediaContainer soundData = null;
    float initialGain = 1.0f;
    int loopCount = 0;
    boolean enable = false;
    boolean release = false;
    boolean continuous = false;
    boolean mute = false;
    boolean pause = false;
    float priority = 1.0f;
    float rate = 1.0f;
    Bounds schedulingRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds transformedRegion = null;
    static final int SOUND_DATA_DIRTY_BIT = 1;
    static final int INITIAL_GAIN_DIRTY_BIT = 2;
    static final int LOOP_COUNT_DIRTY_BIT = 4;
    static final int BOUNDS_DIRTY_BIT = 8;
    static final int BOUNDING_LEAF_DIRTY_BIT = 16;
    static final int PRIORITY_DIRTY_BIT = 32;
    static final int POSITION_DIRTY_BIT = 64;
    static final int DISTANCE_GAIN_DIRTY_BIT = 128;
    static final int BACK_DISTANCE_GAIN_DIRTY_BIT = 256;
    static final int DIRECTION_DIRTY_BIT = 512;
    static final int ANGULAR_ATTENUATION_DIRTY_BIT = 1024;
    static final int RATE_DIRTY_BIT = 2048;
    static final int BOUNDS_CHANGED = 24;
    static final int ATTRIBUTE_DIRTY_BITS = 2087;
    static final int POSITIONAL_DIRTY_BITS = 2279;
    static final int DIRECTIONAL_DIRTY_BITS = 4071;
    static final int ALL_ATTIBS_DIRTY_BITS = 4095;
    static final int LIVE_DIRTY_BIT = 1;
    static final int IMMEDIATE_MODE_DIRTY_BIT = 2;
    static final int LOAD_SOUND_DIRTY_BIT = 4;
    static final int RELEASE_DIRTY_BIT = 8;
    static final int CONTINUOUS_DIRTY_BIT = 16;
    static final int ENABLE_DIRTY_BIT = 32;
    static final int MUTE_DIRTY_BIT = 64;
    static final int PAUSE_DIRTY_BIT = 128;
    static final int XFORM_DIRTY_BIT = 32768;
    static final int ALL_STATE_DIRTY_BITS = 33023;
    int soundType = -1;
    SoundRetained sgSound = null;
    HashKey key = null;
    SoundRetained[] mirrorSounds = new SoundRetained[1];
    int numMirrorSounds = 0;
    private SoundSchedulerAtom[] loadedAtoms = new SoundSchedulerAtom[1];
    private int atomCount = 0;
    boolean inImmCtx = false;
    static final int LOAD_COMPLETE = 2;
    static final int LOAD_PENDING = 1;
    static final int LOAD_NULL = 0;
    static final int LOAD_FAILED = -1;
    int loadStatus = 0;
    long duration = -1L;
    static final int targetThreads = 514;
    boolean isViewScoped = false;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundRetained() {
    }

    void dispatchAttribChange(int n2, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 514;
        j3dMessage.type = 38;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorSounds) : new Integer(1);
        j3dMessage.args[3] = this.mirrorSounds.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void dispatchStateChange(int n2, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 514;
        j3dMessage.type = 45;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorSounds) : new Integer(1);
        j3dMessage.args[3] = this.mirrorSounds.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setSoundDataState(MediaContainer mediaContainer) {
        this.soundData = mediaContainer;
    }

    void setSoundData(MediaContainer mediaContainer) {
        if (this.soundData == mediaContainer) {
            return;
        }
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).removeUser(this);
        }
        if (this.source != null && this.source.isLive()) {
            if (this.soundData != null) {
                ((MediaContainerRetained)this.soundData.retained).clearLive(this.refCount);
            }
            if (mediaContainer != null) {
                ((MediaContainerRetained)mediaContainer.retained).setLive(this.inBackgroundGroup, this.refCount);
                ((MediaContainerRetained)mediaContainer.retained).addUser(this);
            }
        }
        this.soundData = mediaContainer;
        this.dispatchAttribChange(1, mediaContainer);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    MediaContainer getSoundData() {
        return this.soundData;
    }

    void setInitialGain(float f2) {
        this.initialGain = f2 < 0.0f ? 0.0f : f2;
        this.dispatchAttribChange(2, new Float(f2));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    float getInitialGain() {
        return this.initialGain;
    }

    void setLoop(int n2) {
        this.loopCount = n2 < -1 ? -1 : n2;
        this.dispatchAttribChange(4, new Integer(n2));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    int getLoop() {
        return this.loopCount;
    }

    void setReleaseEnable(boolean bl) {
        this.release = bl;
        this.dispatchAttribChange(8, bl ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    boolean getReleaseEnable() {
        return this.release;
    }

    void setContinuousEnable(boolean bl) {
        this.continuous = bl;
        this.dispatchAttribChange(16, bl ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    boolean getContinuousEnable() {
        return this.continuous;
    }

    void setEnable(boolean bl) {
        this.enable = bl;
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
        this.dispatchStateChange(32, new Boolean(this.enable));
    }

    boolean getEnable() {
        return this.enable;
    }

    void setSchedulingBounds(Bounds bounds) {
        if (bounds != null) {
            this.schedulingRegion = (Bounds)bounds.clone();
            if (this.staticTransform != null) {
                this.schedulingRegion.transform(this.staticTransform.transform);
            }
            this.transformedRegion = (Bounds)this.schedulingRegion.clone();
        } else {
            this.schedulingRegion = null;
            this.transformedRegion = null;
        }
        this.dispatchAttribChange(8, bounds);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    Bounds getSchedulingBounds() {
        Bounds bounds = null;
        if (this.schedulingRegion != null) {
            bounds = (Bounds)this.schedulingRegion.clone();
            if (this.staticTransform != null) {
                Transform3D transform3D = this.staticTransform.getInvTransform();
                bounds.transform(transform3D);
            }
        }
        return bounds;
    }

    void setSchedulingBoundingLeaf(BoundingLeaf boundingLeaf) {
        int n2;
        int n3 = this.numMirrorSounds;
        if (this.numMirrorSounds == 0) {
            n3 = 1;
        }
        if (this.boundingLeaf != null && this.source != null && this.source.isLive()) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorSounds[n2]);
            }
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            if (this.source != null && this.source.isLive()) {
                for (n2 = 0; n2 < n3; ++n2) {
                    this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorSounds[n2]);
                }
            }
        } else {
            this.boundingLeaf = null;
        }
        this.dispatchAttribChange(16, boundingLeaf);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    BoundingLeaf getSchedulingBoundingLeaf() {
        if (this.boundingLeaf != null) {
            return (BoundingLeaf)this.boundingLeaf.source;
        }
        return null;
    }

    synchronized void updateMirrorObject(Object[] objectArray) {
        Object var2_2 = null;
        int n2 = (Integer)objectArray[1];
        if (n2 == -1) {
            this.initMirrorObject((SoundRetained)objectArray[2]);
        }
        super.updateMirrorObject(objectArray);
    }

    void updateBoundingLeaf(long l2) {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.transformedRegion;
        } else if (this.schedulingRegion != null) {
            this.transformedRegion = this.schedulingRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.schedulingRegion, this.getLastLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
    }

    void setPriority(float f2) {
        if (f2 == this.priority) {
            return;
        }
        this.priority = f2;
        this.dispatchAttribChange(32, new Float(f2));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    float getPriority() {
        return this.priority;
    }

    long getDuration() {
        return this.duration;
    }

    void setRateScaleFactor(float f2) {
        this.rate = f2;
        this.dispatchAttribChange(2048, new Float(f2));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    float getRateScaleFactor() {
        return this.rate;
    }

    void changeAtomList(SoundSchedulerAtom soundSchedulerAtom, int n2) {
        if (soundSchedulerAtom == null) {
            return;
        }
        if (n2 == 2) {
            int n3;
            for (n3 = 0; n3 < this.atomCount; ++n3) {
                if (soundSchedulerAtom != this.loadedAtoms[n3]) continue;
                return;
            }
            ++this.atomCount;
            n3 = this.loadedAtoms.length;
            if (this.atomCount > n3) {
                this.loadedAtoms = new SoundSchedulerAtom[2 * n3];
            }
            this.loadedAtoms[this.atomCount - 1] = soundSchedulerAtom;
            this.duration = soundSchedulerAtom.sampleLength;
        } else {
            if (this.atomCount == 0) {
                return;
            }
            boolean bl = false;
            for (int i2 = 0; i2 < this.atomCount; ++i2) {
                if (soundSchedulerAtom != this.loadedAtoms[i2]) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            for (int i3 = i2; i3 < this.atomCount; ++i3) {
                this.loadedAtoms[i3] = this.loadedAtoms[i3 + 1];
            }
            --this.atomCount;
            if (this.atomCount == 0) {
                this.duration = -1L;
            }
        }
    }

    boolean isReady() {
        boolean bl = true;
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[i2];
            if (soundSchedulerAtom == null || soundSchedulerAtom.soundScheduler == null) continue;
            if (soundSchedulerAtom.loadStatus == 2) {
                bl = true;
                continue;
            }
            return false;
        }
        return bl;
    }

    boolean isReady(View view) {
        if (view == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[i2];
            if (soundSchedulerAtom == null || soundSchedulerAtom.soundScheduler == null || soundSchedulerAtom.soundScheduler.view != view) continue;
            return soundSchedulerAtom.loadStatus == 2;
        }
        return false;
    }

    boolean isPlaying() {
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[i2];
            if (soundSchedulerAtom == null || soundSchedulerAtom.soundScheduler == null || soundSchedulerAtom.status != 1) continue;
            return true;
        }
        return false;
    }

    boolean isPlaying(View view) {
        if (view == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[i2];
            if (soundSchedulerAtom == null || soundSchedulerAtom.soundScheduler == null || soundSchedulerAtom.soundScheduler.view != view) continue;
            return soundSchedulerAtom.status == 1;
        }
        return false;
    }

    boolean isPlayingSilently() {
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[i2];
            if (soundSchedulerAtom == null || soundSchedulerAtom.soundScheduler == null) continue;
            return soundSchedulerAtom.status == 2;
        }
        return false;
    }

    boolean isPlayingSilently(View view) {
        if (view == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[i2];
            if (soundSchedulerAtom == null || soundSchedulerAtom.soundScheduler == null || soundSchedulerAtom.soundScheduler.view != view) continue;
            return soundSchedulerAtom.status == 2;
        }
        return false;
    }

    int getNumberOfChannelsUsed() {
        View view = this.universe.getCurrentView();
        if (view == null) {
            return 0;
        }
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[i2];
            if (soundSchedulerAtom == null || soundSchedulerAtom.soundScheduler == null || soundSchedulerAtom.soundScheduler.view != view) continue;
            return soundSchedulerAtom.numberChannels;
        }
        return 0;
    }

    int getNumberOfChannelsUsed(View view) {
        if (view == null) {
            return 0;
        }
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[i2];
            if (soundSchedulerAtom == null || soundSchedulerAtom.soundScheduler == null || soundSchedulerAtom.soundScheduler.view != view) continue;
            return soundSchedulerAtom.numberChannels;
        }
        return 0;
    }

    void setMute(boolean bl) {
        this.mute = bl;
        this.dispatchAttribChange(64, bl ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    boolean getMute() {
        return this.mute;
    }

    void setPause(boolean bl) {
        this.pause = bl;
        this.dispatchAttribChange(128, bl ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    boolean getPause() {
        return this.pause;
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    SoundRetained getMirrorSound(HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2;
            for (n2 = 0; n2 < this.numMirrorSounds; ++n2) {
                if (!this.mirrorSounds[n2].key.equals((Object)hashKey)) continue;
                return this.mirrorSounds[n2];
            }
            if (this.numMirrorSounds == this.mirrorSounds.length) {
                SoundRetained[] soundRetainedArray = new SoundRetained[this.numMirrorSounds * 2];
                for (n2 = 0; n2 < this.numMirrorSounds; ++n2) {
                    soundRetainedArray[n2] = this.mirrorSounds[n2];
                }
                this.mirrorSounds = soundRetainedArray;
            }
            this.mirrorSounds[this.numMirrorSounds] = (SoundRetained)this.clone();
            this.mirrorSounds[this.numMirrorSounds].key = hashKey;
            this.mirrorSounds[this.numMirrorSounds].sgSound = this;
            return this.mirrorSounds[this.numMirrorSounds++];
        }
        if (this.mirrorSounds[0] == null) {
            this.mirrorSounds[0] = (SoundRetained)this.clone();
            this.mirrorSounds[0].sgSound = this;
        }
        return this.mirrorSounds[0];
    }

    synchronized void initMirrorObject(SoundRetained soundRetained) {
        Object var4_2 = null;
        soundRetained.setSchedulingBounds(this.getSchedulingBounds());
        soundRetained.setSchedulingBoundingLeaf(this.getSchedulingBoundingLeaf());
        soundRetained.sgSound = this.sgSound;
        soundRetained.inImmCtx = this.inImmCtx;
        soundRetained.setSoundData(this.getSoundData());
        soundRetained.parent = this.parent;
        soundRetained.inSharedGroup = false;
        soundRetained.locale = this.locale;
        soundRetained.parent = this.parent;
        soundRetained.localBounds = (Bounds)this.localBounds.clone();
        soundRetained.transformedRegion = null;
        if (this.boundingLeaf != null) {
            if (soundRetained.boundingLeaf != null) {
                soundRetained.boundingLeaf.removeUser(soundRetained);
            }
            soundRetained.boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
            soundRetained.boundingLeaf.addUser(soundRetained);
            soundRetained.transformedRegion = soundRetained.boundingLeaf.transformedRegion;
        } else {
            soundRetained.boundingLeaf = null;
        }
        if (this.schedulingRegion != null) {
            soundRetained.schedulingRegion = (Bounds)this.schedulingRegion.clone();
            if (soundRetained.transformedRegion == null) {
                soundRetained.transformedRegion = (Bounds)soundRetained.schedulingRegion.clone();
                soundRetained.transformedRegion.transform(soundRetained.schedulingRegion, soundRetained.getLastLocalToVworld());
            }
        } else {
            soundRetained.schedulingRegion = null;
        }
    }

    void setLive(SetLiveState setLiveState) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("SoundRetained2"));
        }
        super.setLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("SoundRetained3"));
        }
        if (this.loadStatus == 1) {
            this.dispatchStateChange(4, this.soundData);
        }
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).setLive(this.inBackgroundGroup, setLiveState.refCount);
        }
        if (setLiveState.inSharedGroup) {
            for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                SoundRetained soundRetained = this.getMirrorSound(setLiveState.keys[i2]);
                soundRetained.localToVworld = new Transform3D[1][];
                soundRetained.localToVworldIndex = new int[1][];
                int n2 = setLiveState.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 < 0) {
                    System.err.println("SoundRetained : Can't find hashKey");
                }
                soundRetained.localToVworld[0] = this.localToVworld[n2];
                soundRetained.localToVworldIndex[0] = this.localToVworldIndex[n2];
                if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
                    setLiveState.viewScopedNodeList.add(soundRetained);
                    setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(i2));
                } else {
                    setLiveState.nodeList.add(soundRetained);
                }
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[i2] != null) {
                    setLiveState.switchTargets[i2].addNode(soundRetained, 3);
                }
                soundRetained.switchState = (SwitchState)setLiveState.switchStates.get(n2);
                if (setLiveState.transformTargets == null || setLiveState.transformTargets[i2] == null) continue;
                setLiveState.transformTargets[i2].addNode(soundRetained, 3);
                setLiveState.notifyThreads |= 0x2000;
            }
        } else {
            SoundRetained soundRetained = this.getMirrorSound(null);
            soundRetained.localToVworld = new Transform3D[1][];
            soundRetained.localToVworldIndex = new int[1][];
            soundRetained.localToVworld[0] = this.localToVworld[0];
            soundRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
                setLiveState.viewScopedNodeList.add(soundRetained);
                setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
            } else {
                setLiveState.nodeList.add(soundRetained);
            }
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(soundRetained, 3);
            }
            soundRetained.switchState = (SwitchState)setLiveState.switchStates.get(0);
            if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                setLiveState.transformTargets[0].addNode(soundRetained, 3);
                setLiveState.notifyThreads |= 0x2000;
            }
        }
        this.dispatchStateChange(1, this.soundData);
        setLiveState.notifyThreads |= 0x202;
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (setLiveState.inSharedGroup) {
            for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                SoundRetained soundRetained = this.getMirrorSound(setLiveState.keys[i2]);
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[i2] != null) {
                    setLiveState.switchTargets[i2].addNode(soundRetained, 3);
                }
                if (setLiveState.transformTargets != null && setLiveState.transformTargets[i2] != null) {
                    setLiveState.transformTargets[i2].addNode(soundRetained, 3);
                    setLiveState.notifyThreads |= 0x2000;
                }
                if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
                    setLiveState.viewScopedNodeList.add(soundRetained);
                    setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(i2));
                    continue;
                }
                setLiveState.nodeList.add(soundRetained);
            }
        } else {
            SoundRetained soundRetained = this.getMirrorSound(null);
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(soundRetained, 3);
            }
            if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                setLiveState.transformTargets[0].addNode(soundRetained, 3);
                setLiveState.notifyThreads |= 0x2000;
            }
            if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
                setLiveState.viewScopedNodeList.add(soundRetained);
                setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
            } else {
                setLiveState.nodeList.add(soundRetained);
            }
        }
        setLiveState.notifyThreads |= 0x202;
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).clearLive(setLiveState.refCount);
        }
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        if (this.schedulingRegion != null) {
            this.schedulingRegion.transform(transformGroupRetained.transform);
        }
    }

    void updateTransformChange() {
        if (this.boundingLeaf == null && this.schedulingRegion != null) {
            this.transformedRegion = this.schedulingRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.schedulingRegion, this.getLastLocalToVworld());
        }
        this.dispatchStateChange(32768, null);
    }

    void debugPrint(String string) {
    }

    void getMirrorObjects(ArrayList arrayList, HashKey hashKey) {
        if (hashKey == null) {
            arrayList.add(this.mirrorSounds[0]);
        } else {
            for (int i2 = 0; i2 < this.numMirrorSounds; ++i2) {
                if (!this.mirrorSounds[i2].key.equals((Object)hashKey)) continue;
                arrayList.add(this.mirrorSounds[i2]);
                break;
            }
        }
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

